import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:zcart_delivery/providers/order_provider.dart';

class OtpCompleteOrderPage extends ConsumerStatefulWidget {
  final int orderId;
  final int otp;
  const OtpCompleteOrderPage({
    super.key,
    required this.orderId,
    required this.otp,
  });

  @override
  ConsumerState<OtpCompleteOrderPage> createState() =>
      _OtpCompleteOrderPageState();
}

class _OtpCompleteOrderPageState extends ConsumerState<OtpCompleteOrderPage> {
  final TextEditingController _otpController = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => FocusScope.of(context).unfocus(),
      child: Scaffold(
        appBar: AppBar(
          title: const Text('Enter OTP to Complete Order'),
          shape: const RoundedRectangleBorder(borderRadius: BorderRadius.zero),
        ),
        body: Center(
          child: SingleChildScrollView(
            padding: const EdgeInsets.all(24),
            child: Column(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.stretch,
              children: [
                Text(
                  'Enter OTP to Complete Order',
                  textAlign: TextAlign.center,
                  style: Theme.of(context)
                      .textTheme
                      .titleSmall!
                      .copyWith(fontWeight: FontWeight.bold),
                ),
                const SizedBox(height: 24),
                TextField(
                  controller: _otpController,
                  keyboardType: TextInputType.number,
                  maxLength: 6,
                  style: Theme.of(context).textTheme.headlineMedium,
                  textAlign: TextAlign.center,
                  inputFormatters: [FilteringTextInputFormatter.digitsOnly],
                  decoration: const InputDecoration(
                    border: OutlineInputBorder(
                      borderRadius: BorderRadius.all(Radius.circular(8)),
                    ),
                    hintText: '******',
                  ),
                ),
                const SizedBox(height: 24),
                ElevatedButton(
                  onPressed: () async {
                    if (_otpController.text.isNotEmpty) {
                      if (widget.otp == int.parse(_otpController.text.trim())) {
                        ScaffoldMessenger.of(context).showSnackBar(
                          const SnackBar(
                            content: Text("Valid OTP. Updating status..."),
                            duration: Duration(seconds: 1),
                          ),
                        );
                        Future.delayed(const Duration(seconds: 2));
                        await OrderController.updateStatus(widget.orderId, 6)
                            .then((result) {
                          if (result == true) {
                            ref.invalidate(orderProvider(widget.orderId));
                            ref.invalidate(ordersProvider);
                            ScaffoldMessenger.of(context).showSnackBar(
                              const SnackBar(
                                content:
                                    Text("Order status updated successfully"),
                                duration: Duration(seconds: 3),
                              ),
                            );
                            Navigator.pop(context);
                          } else {
                            ScaffoldMessenger.of(context).showSnackBar(
                              const SnackBar(
                                content: Text("Failed to update order status"),
                                duration: Duration(seconds: 3),
                              ),
                            );
                          }
                        });
                      } else {
                        ScaffoldMessenger.of(context).showSnackBar(
                          const SnackBar(
                            content: Text("Invalid OTP"),
                            duration: Duration(seconds: 3),
                          ),
                        );
                      }
                    } else {
                      ScaffoldMessenger.of(context).showSnackBar(
                        const SnackBar(
                          content: Text("Please enter OTP"),
                          duration: Duration(seconds: 3),
                        ),
                      );
                    }
                  },
                  child: const Text('Submit'),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
